/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.explosion;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendKnockbackPacket;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1900;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_47;
import net.minecraft.class_5361;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class BombExplosion
extends class_1927 {
    private final float radius;
    private final class_1937 level;
    private final double x;
    private final double y;
    private final double z;
    private final BombEntity.BombType bombType;
    private final class_5362 damageCalculator;
    private final ObjectArrayList<class_2338> toBlow = new ObjectArrayList();
    private final Map<class_1657, class_243> hitPlayers = Maps.newHashMap();
    private final class_1927.class_4179 mode;
    private static final class_5362 EXPLOSION_DAMAGE_CALCULATOR = new class_5362();

    public BombExplosion(class_1937 world, @Nullable class_1297 entity, @Nullable class_1282 damageSource, @Nullable class_5362 context, double x, double y, double z, float radius, BombEntity.BombType bombType, class_1927.class_4179 interaction) {
        super(world, entity, damageSource, context, x, y, z, radius, false, interaction);
        this.level = world;
        this.radius = radius;
        this.x = x;
        this.y = y;
        this.z = z;
        this.bombType = bombType;
        this.mode = interaction;
        this.damageCalculator = context == null ? this.bombMakeDamageCalculator(entity) : context;
    }

    private class_5362 bombMakeDamageCalculator(@Nullable class_1297 entity) {
        return entity == null ? EXPLOSION_DAMAGE_CALCULATOR : new class_5361(entity);
    }

    public void doFinalizeExplosion() {
        this.level.method_43128(null, this.x, this.y, this.z, ModSounds.BOMB_EXPLOSION.get(), class_3419.field_15254, this.bombType.volume(), 1.2f + (this.level.field_9229.method_43057() - this.level.field_9229.method_43057()) * 0.2f);
        ObjectArrayList drops = new ObjectArrayList();
        class_156.method_43028(this.toBlow, (class_5819)this.level.field_9229);
        for (class_2338 blockpos : this.toBlow) {
            class_1937 class_19372;
            class_2680 blockstate = this.level.method_8320(blockpos);
            if (blockstate.method_26215()) continue;
            class_2338 immutable = blockpos.method_10062();
            this.level.method_16107().method_15396("explosion_blocks");
            if (ForgeHelper.canDropFromExplosion((class_2680)blockstate, (class_1937)this.level, (class_2338)blockpos, (class_1927)this) && (class_19372 = this.level) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                class_2586 blockEntity = blockstate.method_31709() ? this.level.method_8321(blockpos) : null;
                class_47.class_48 builder = new class_47.class_48(serverLevel).method_311(this.level.field_9229).method_312(class_181.field_24424, (Object)class_243.method_24953((class_2382)blockpos)).method_312(class_181.field_1229, (Object)class_1799.field_8037).method_306(class_181.field_1228, (Object)blockEntity).method_306(class_181.field_1226, (Object)this.field_9185);
                if (this.mode == class_1927.class_4179.field_18687) {
                    builder.method_312(class_181.field_1225, (Object)Float.valueOf(this.radius));
                }
                blockstate.method_26189(builder).forEach(stack -> BombExplosion.addBlockDrops((ObjectArrayList<Pair<class_1799, class_2338>>)drops, stack, immutable));
            }
            ForgeHelper.onBlockExploded((class_2680)blockstate, (class_1937)this.level, (class_2338)blockpos, (class_1927)this);
            this.level.method_16107().method_15407();
        }
        for (Pair pair : drops) {
            class_2248.method_9577((class_1937)this.level, (class_2338)((class_2338)pair.getSecond()), (class_1799)((class_1799)pair.getFirst()));
        }
    }

    private static void addBlockDrops(ObjectArrayList<Pair<class_1799, class_2338>> drops, class_1799 stack, class_2338 pos) {
        int i = drops.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)drops.get(j);
            class_1799 itemstack = (class_1799)pair.getFirst();
            if (!class_1542.method_24017((class_1799)itemstack, (class_1799)stack)) continue;
            class_1799 itemStack = class_1542.method_24018((class_1799)itemstack, (class_1799)stack, (int)16);
            drops.set(j, (Object)Pair.of((Object)itemStack, (Object)((class_2338)pair.getSecond())));
            if (!stack.method_7960()) continue;
            return;
        }
        drops.add((Object)Pair.of((Object)stack, (Object)pos));
    }

    public void method_8348() {
        class_1657 pl;
        class_1676 pr;
        class_1657 owner;
        this.level.method_33596(this.field_9185, class_5712.field_28178, new class_2338(this.x, this.y, this.z));
        HashSet set = Sets.newHashSet();
        class_1297 class_12972 = this.field_9185;
        class_1657 class_16572 = owner = class_12972 instanceof class_1676 && (class_12972 = (pr = (class_1676)class_12972).method_24921()) instanceof class_1657 ? (pl = (class_1657)class_12972) : null;
        if (this.mode != class_1927.class_4179.field_18685) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    for (int l = 0; l < 16; ++l) {
                        if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                        double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                        double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                        double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        double d4 = this.x;
                        double d6 = this.y;
                        double d8 = this.z;
                        float f1 = 0.3f;
                        for (float f = this.radius * (0.7f + this.level.field_9229.method_43057() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                            class_3610 fluidstate;
                            class_2338 blockpos = new class_2338(d4, d6, d8);
                            class_2680 blockstate = this.level.method_8320(blockpos);
                            Optional optional = this.damageCalculator.method_29555((class_1927)this, (class_1922)this.level, blockpos, blockstate, fluidstate = this.level.method_8316(blockpos));
                            if (optional.isPresent()) {
                                f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                            }
                            if (f > 0.0f && this.damageCalculator.method_29554((class_1927)this, (class_1922)this.level, blockpos, blockstate, f) && (owner == null || !CompatHandler.FLAN || FlanCompat.canBreak(owner, blockpos))) {
                                set.add(blockpos);
                            }
                            d4 += d0 * (double)0.3f;
                            d6 += d1 * (double)0.3f;
                            d8 += d2 * (double)0.3f;
                        }
                    }
                }
            }
        }
        this.toBlow.addAll((Collection)set);
        float diameter = this.radius * 2.0f;
        int k1 = class_3532.method_15357((double)(this.x - (double)diameter - 1.0));
        int l1 = class_3532.method_15357((double)(this.x + (double)diameter + 1.0));
        int i2 = class_3532.method_15357((double)(this.y - (double)diameter - 1.0));
        int i1 = class_3532.method_15357((double)(this.y + (double)diameter + 1.0));
        int j2 = class_3532.method_15357((double)(this.z - (double)diameter - 1.0));
        int j1 = class_3532.method_15357((double)(this.z + (double)diameter + 1.0));
        List list = this.level.method_8335((class_1297)this.method_8347(), new class_238((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeHelper.onExplosionDetonate((class_1937)this.level, (class_1927)this, (List)list, (double)diameter);
        class_243 vector3d = new class_243(this.x, this.y, this.z);
        for (class_1297 class_12973 : list) {
            double dz;
            double dy;
            double dx;
            double distFromCenterSqr;
            double distSq;
            double normalizedDist;
            if (class_12973.method_5659() || owner != null && CompatHandler.FLAN && !FlanCompat.canAttack(owner, class_12973) || !((normalizedDist = (double)(class_3532.method_15355((float)((float)(distSq = class_12973.method_5707(vector3d)))) / diameter)) <= 1.0) || (distFromCenterSqr = (double)class_3532.method_15355((float)((float)((dx = class_12973.method_23317() - this.x) * dx + (dy = (class_12973 instanceof class_1541 ? class_12973.method_23318() : class_12973.method_23320()) - this.y) * dy + (dz = class_12973.method_23321() - this.z) * dz)))) == 0.0) continue;
            dx /= distFromCenterSqr;
            dy /= distFromCenterSqr;
            dz /= distFromCenterSqr;
            double d14 = BombExplosion.method_17752((class_243)vector3d, (class_1297)class_12973);
            double d10 = (1.0 - normalizedDist) * d14;
            class_12973.method_5643(this.method_8349(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)diameter + 1.0)));
            double d11 = d10;
            boolean isPlayer = class_12973 instanceof class_1657;
            class_1657 playerEntity = null;
            if (!(!isPlayer || (playerEntity = (class_1657)class_12973).method_7325() || playerEntity.method_7337() && playerEntity.method_31549().field_7479)) {
                this.hitPlayers.put(playerEntity, new class_243(dx * d10, dy * d10, dz * d10));
            }
            if (class_12973 instanceof class_1309) {
                class_1309 livingEntity = (class_1309)class_12973;
                if (!isPlayer || !playerEntity.method_7325() && !playerEntity.method_7337()) {
                    this.bombType.applyStatusEffects(livingEntity, distSq);
                }
                if (class_12973 instanceof class_1548) {
                    class_1548 creeper = (class_1548)class_12973;
                    creeper.method_7004();
                }
                d11 = class_1900.method_8237((class_1309)((class_1309)class_12973), (double)d10);
            }
            class_12973.method_18799(class_12973.method_18798().method_1031(dx * d11, dy * d11, dz * d11));
        }
        if (!this.level.field_9236) {
            for (Map.Entry entry : this.hitPlayers.entrySet()) {
                NetworkHandler.CHANNEL.sendToClientPlayer((class_3222)entry.getKey(), (Message)new ClientBoundSendKnockbackPacket((class_243)entry.getValue(), ((class_1657)entry.getKey()).method_5628()));
            }
        }
        this.bombType.afterExploded(this, this.level);
    }
}

